/**
  Copyright (c) 2008 Freescale Semiconductor
  Freescale Confidential Proprietary
  \file       Pwm_Cfg.h
  \brief      This file contains all Port Configuration Structures to be used \n
              as Pwm channels.  
  \author     Freescale Semiconductor
  \author     r01160
  \author     Guadalajara Applications Laboratory RTAC Americas
  \version    0.1
  \date       4/14/2008 5:07:09 PM
  \warning    USER MUST CONFIGRE THE NUMBER OF TOTAL PWM CHANNELS TO USED!
  
  * History:
  
*/
#ifndef PORT_CFG_H
 #define PORT_CFG_H
 
 #include "typedefs.h"
 #include "Adc_Cfg.h"
 
  /** Boolean Condition definitions */
#ifndef ON
  #define ON   0x01
#endif

#ifndef OFF  
  #define OFF  0x00
#endif  
 
 /*///////////////////////////// LAYER ENABLING DEFINITIONS ////////////////////////*/
 /** Pit & emios Interrupts shall be handle by Z0 core               */
 #define Z0_CORE         ON
 /** Enables switching delay between PWM channels to avoid inrush currents for EMC evaluation tests */
 #define PWM_INIT_DELAY  OFF
 /** This definition indicates if Diagnostics will be enabled or not */
 #define DIAGNOSTICS     OFF
 /*////////////////////////////////////////////////////////////////////////////////*/
  
  
 /*----------------------------- Defines ---------------------------*/
/** This macro enabled the Pwm Error Layer */
 #define PWM_ERROR_DETECT  ON
 
 /** Used to specify which PIT channel shall be assigned as a base timer to generate PWM signals */
 #define PIT_ASSIGNED_CHANNEL   PIT_CH_1
 /********************************** PORT CONFIGURATION SECTION ***************************/
 /** Port Indexes Name Definitions */
 #define PORTB_PIN_0    ((uint8_t)16)
 #define PORTB_PIN_1    ((uint8_t)17)
 #define PORTB_PIN_2    ((uint8_t)18)
 #define PORTB_PIN_3    ((uint8_t)19)
 #define PORTB_PIN_4    ((uint8_t)20)
 #define PORTB_PIN_5    ((uint8_t)21)
 #define PORTB_PIN_6    ((uint8_t)22)
 #define PORTB_PIN_7    ((uint8_t)23)
 #define PORTB_PIN_8    ((uint8_t)24)
 #define PORTB_PIN_9    ((uint8_t)25)
 #define PORTB_PIN_10   ((uint8_t)26)
 #define PORTB_PIN_11   ((uint8_t)27)
 #define PORTB_PIN_12   ((uint8_t)28)
 #define PORTB_PIN_13   ((uint8_t)29)
 #define PORTB_PIN_14   ((uint8_t)30)
 #define PORTB_PIN_15   ((uint8_t)31)
 /********************************** END OF PORT CONFIGURATION SECTION ***************************/ 
 #define DUTY_CYCLE_100      (uint32_t) (303) 
 #define DUTY_CYCLE_150      (uint32_t) (202) 
 
 #define MAX_DUTY_CYCLE      (uint32_t) (DUTY_CYCLE_100)  
 /** Number of Pwm channels */
 #define PWM_MAX_CHANNELS     4
 
 /** Pwm period frequencies  */
 #define SET_PERIOD_AT_150HZ   ((uint32_t)0x000000CA)
 #define SET_PERIOD_AT_100HZ   ((uint32_t)0x0000012F)
 
 /** Duty Cycles useful for 100Hz frequency only */
 #define DTY_AT_5P_WITH_100HZ    (uint32_t) (((uint32_t)5 *(uint32_t)DUTY_CYCLE_100)/((uint32_t)100))
 #define DTY_AT_20P_WITH_100HZ   (uint32_t) (((uint32_t)20*(uint32_t)DUTY_CYCLE_100)/((uint32_t)100))
 #define DTY_AT_50P_WITH_100HZ   (uint32_t) (((uint32_t)50*(uint32_t)DUTY_CYCLE_100)/((uint32_t)100))
 #define DTY_AT_65P_WITH_100HZ   (uint32_t) (((uint32_t)65*(uint32_t)DUTY_CYCLE_100)/((uint32_t)100))
 #define DTY_AT_70P_WITH_100HZ   (uint32_t) (((uint32_t)70*(uint32_t)DUTY_CYCLE_100)/((uint32_t)100))
 #define DTY_AT_90P_WITH_100HZ   (uint32_t) (((uint32_t)90*(uint32_t)DUTY_CYCLE_100)/((uint32_t)100))
 
 /** Duty Cycles useful for 150Hz frequency only */
 #define DTY_AT_5P_WITH_150HZ    (uint32_t) (((uint32_t)5*(uint32_t)DUTY_CYCLE_150)/((uint32_t)100))
 #define DTY_AT_20P_WITH_150HZ   (uint32_t) (((uint32_t)20*(uint32_t)DUTY_CYCLE_150)/((uint32_t)100))
 #define DTY_AT_50P_WITH_150HZ   (uint32_t) (((uint32_t)50*(uint32_t)DUTY_CYCLE_150)/((uint32_t)100))
 #define DTY_AT_65P_WITH_150HZ   (uint32_t) (((uint32_t)65*(uint32_t)DUTY_CYCLE_150)/((uint32_t)100))
 #define DTY_AT_70P_WITH_150HZ   (uint32_t) (((uint32_t)70*(uint32_t)DUTY_CYCLE_150)/((uint32_t)100))
 #define DTY_AT_90P_WITH_150HZ   (uint32_t) (((uint32_t)90*(uint32_t)DUTY_CYCLE_150)/((uint32_t)100))
 
 /** Pwm Channel Names. Used as a reference for Duty Cycle & Period functions */
 #define PWM_CHANNEL_0           ((uint8_t)0)
 #define PWM_CHANNEL_1           ((uint8_t)1)
 #define PWM_CHANNEL_2           ((uint8_t)2)
 #define PWM_CHANNEL_3           ((uint8_t)3)
 #define PWM_CHANNEL_4           ((uint8_t)4)
 #define PWM_CHANNEL_5           ((uint8_t)5)
 #define PWM_CHANNEL_6           ((uint8_t)6)
 #define PWM_CHANNEL_7           ((uint8_t)7)
 #define PWM_CHANNEL_8           ((uint8_t)8)
 #define PWM_CHANNEL_9           ((uint8_t)9)
 #define PWM_CHANNEL_10          ((uint8_t)10)
 #define PWM_CHANNEL_11          ((uint8_t)11)
 #define PWM_CHANNEL_12          ((uint8_t)12)
 #define PWM_CHANNEL_13          ((uint8_t)13)
 #define PWM_CHANNEL_14          ((uint8_t)14)
 #define PWM_CHANNEL_15          ((uint8_t)15)
 

 /** Pwm Polarity States */
 #define PWM_HIGH  1
 #define PWM_LOW   0
 
 /*----------------------------- Structures ------------------------*/
 
  /** Pwm Channel Configuration Parameters */
	typedef struct
	{
	    uint8_t  u8Pwm_Channel_Id;        /* Pwm channel name                        */
	    uint8_t  u8Pwm_Port_Channel;      /* Assigned HW channel                     */
	    uint32_t u32Period;               /* Pwm Period Value                        */
	    uint32_t u32Duty;                 /* Pwm duty Cycle                          */
	    uint32_t u32Cntr;                 /* Duty Cycle Counter                      */
	  #if (DIAGNOSTICS == ON)             /* Check if Diagnostics is needed          */
	    uint32_t u32Adc_Channel_No;       /* Assigned Channel Number                 */ 
	    uint32_t u32Adc_Trigger_Value;    /* Trigger value when ADC start conversion */
	    uint32_t u32Adc_Fifo_Buffer;      /* Saves Adc conversions                   */
	  #endif   
	} Pwm_ChannelConfigType;
	
 	
extern Pwm_ChannelConfigType Pwm_ChannelConfig[]; 
 
#endif